"use strict";

this.name    = "Save and Jump";
this.version = "0.3";
this.author  = "Wildeblood";
this.logging = true;

/* ====================================================================================
			DECIDING WHETHER TO INVOKE SAVE-BEFORE-JUMP
======================================================================================= */

this.playerStartedJumpCountdown = function(type, countdown)
	{
     if (type === "standard") this.$timer = new Timer(this, this.$checkForSaveBeforeJump, countdown - 0.1);
	}

this.playerCancelledJumpCountdown = this.playerJumpFailed = function()
	{
	if (this.$timer)
		{
		this.$timer.stop();
		delete this.$timer;
		}
	}

this.$checkForSaveBeforeJump = function()
	{
	if (this.logging) log (this.name, "Checking for save before jump...");

	if (guiScreen !== "GUI_SCREEN_STATUS" || player.alertCondition === 3) return;
	if (this.logging) log (this.name, "Status screen shown, saving requested.");

	// ----------------------------------------------------------------
	if (this.logging) log (this.name, "Checking for sufficient fuel...");
	var howfar = System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber, player.ship.targetSystem));
	if (howfar > player.ship.fuel)
		{
		if (this.logging) log (this.name, "Insufficient fuel will cause jump to fail. Save before jump obviated.");
		return "insufficient fuel";
		}
	if (this.logging) log (this.name, "Passed check for sufficient fuel.");

	// ----------------------------------------------------------------
	if (this.logging) log (this.name, "Checking for nearby masses...");
	// Thanks, Ahruman & cim
	var psPos = player.ship.position;
	var blockers = system.filteredEntities(this, function (entity) {
		return entity.isShip &&
		entity.mass / psPos.squaredDistanceTo(entity) >= 10;
		}, player.ship, 25600);
	if (blockers.length > 0)
		{
		player.ship.target = blockers[0];
		if (this.logging) log (this.name, "Nearby mass will probably cause jump to fail. Save before jump obviated.");
		return "blocked";
		}
	if (this.logging) log (this.name, "Passed check for nearby masses.");

	// TO-DO...  <------------------------------------------------------------------------------------------------------------
	// if (this.logging) log (this.name, "Checking for fuel injectors in use...");

	this.$saveBeforeJump();
	}

/* ====================================================================================
			SAVING BEFORE JUMPING
======================================================================================= */

this.$saveBeforeJump = function()
	{
	this.$saveAndJump = true;
	missionVariables.saveAndJump = system.name; // Store original system name.
	var destination = System.systemNameForID(player.ship.targetSystem);
	system.name = ("Leaving " + system.name + " for " + destination);
	system.mainStation.dockPlayer();
	system.mainStation.orientation = system.mainStation.orientation.rotate(system.mainStation.vectorUp, Math.PI);
	}

/* ====================================================================================
			BLOCK UNWANTED SCREENS WHILE DOCKED FOR SAVE-AND-JUMP
======================================================================================= */

this.guiScreenChanged = function()
	{
	if (this.$saveAndJump
	&& guiScreen !== "GUI_SCREEN_MAIN" 
	&& guiScreen !== "GUI_SCREEN_OPTIONS" 
	&& guiScreen !== "GUI_SCREEN_STATUS") mission.runScreen({title: (system.name), messageKey: "sandj-wrong-screen"});
	}

/* ====================================================================================
			MINIMIZE DOCKING & LAUNCH TUNNEL EFFECTS
======================================================================================= */

this.shipWillDockWithStation = function()
	{
	if (this.$saveAndJump) timeAccelerationFactor = 16.0;
	}

this.shipDockedWithStation = function()
	{
	if (this.$saveAndJump) timeAccelerationFactor = 0.0625;
	}

this.shipWillLaunchFromStation = function()
	{
	if (this.$saveAndJump) timeAccelerationFactor = 16.0;
	}

/* ====================================================================================
			LOADING A GAME SAVED WITH SAVE-AND-JUMP
======================================================================================= */

this.startUp = function()
	{	
	if (missionVariables.saveAndJump)
		{
		this.$saveAndJump = true;
	//	this.$reorientMainStation();
		player.ship.launch();
		}
	}

/* ====================================================================================
			LAUNCH AND JUMP
======================================================================================= */

this.shipLaunchedFromStation = function()
	{
	if (this.$saveAndJump)
		{
		timeAccelerationFactor = 1.0;
		system.name = missionVariables.saveAndJump;
		delete missionVariables.saveAndJump;
		player.ship.position = player.ship.position.add(player.ship.heading.multiply(1000000));
		this.$autojumper = system.addShips("trader", 1, player.ship.position.add(player.ship.heading.multiply(500)), 0)[0]; 
		this.$autojumper.fuel = player.ship.fuel;
		this.$autojumper.exitSystem(player.ship.targetSystem)
	// TO-DO...  <------------------------------------------------------------------------------------------------------------
	// Random chance 1/128 of misjump or fuel leak, as per normal jumps.
		}
	}

/* ====================================================================================
			CLEAN-UP AFTER SUCCESSFUL JUMP
======================================================================================= */

this.shipExitedWitchspace = function()
	{
	if (this.$saveAndJump)
		{
		this.$saveAndJump = false;
		if (this.$autojumper)
			{
			player.ship.fuel = this.$autojumper.fuel;
			this.$autojumper.remove(true);
			}
		}
	}

/* ====================================================================================
			THE END
======================================================================================= */
